﻿//////////////////////////////////////////////
// ShaderInstanceCustomSlot.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Entity ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

// Standards
#include <string>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ShaderInstanceCustomSlot
	{
		public :
	
			// Constructor, destructor
			ShaderInstanceCustomSlot () noexcept ;
			virtual ~ShaderInstanceCustomSlot () ;

			// Getters
			nkMemory::StringView getTypeName () const ;
			nkMemory::StringView getSemanticName () const ;

			// Setters
			void setSemanticName (nkMemory::StringView value) ;

			// Fonctions à refaire
			virtual unsigned int getDataByteSize () = 0 ;
			virtual void fillDataBuffer (Entity* caller, void* buffer) = 0 ;

		protected :
		
			// Attributs
			// Identification pour aider lors des imports / exports surtout
			nkMemory::String _typeName ;
			// Semantic name
			nkMemory::String _semanticName ;
	} ;
}
